﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class TaxBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Tax GetItem(Guid TaxID, string keyword)
        {
            return TaxDB.GetItem(TaxID, keyword);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<Tax> GetList(Guid TaxID, string keyword)
        {
            return TaxDB.GetList(TaxID, keyword);
        }

       
        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(Tax TaxItem)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                TaxDB.Save(TaxItem);

                myTransactionScope.Complete();
                return true;
            }
        }

        public static bool Delete(Guid TaxID)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                TaxDB.Delete(TaxID);

                myTransactionScope.Complete();
                return true;
            }
        }

        public static List<OrdersTax> GetOrderTaxing(Guid OrderID)
        {
            List<OrdersTax> OrderTaxings = TaxDB.GetOrderTaxing(OrderID);
            return OrderTaxings;

        }

        public static bool SaveOrderTaxation(List<OrdersTax> OrdersTax, Guid OrderID)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                TaxDB.SaveOrderTaxation(OrdersTax,OrderID);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
